@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Hello !</h1>
<p>
    We wanted to inform you that a new user has applied for a career opportunity at {{config('app.name')}}. Here are the application details:
</p>
<p>
<ul>
    <li style="font-size: 16px;">Full Name : <span style="padding-left: 20px;">{{ $name }}</span> </li>
    <li style="font-size: 16px;">Email : <span style="padding-left: 20px;text-transform: lowercase;">{{ $email }}</span> </li>
    <li style="font-size: 16px;">Phone : <span style="padding-left: 20px;">{{ $phone }}</span> </li>
    <li style="font-size: 16px;">Date of Birth : <span style="padding-left: 20px;">{{ $dob }}</span> </li>
    <li style="font-size: 16px;">Gender : <span style="padding-left: 20px;">{{ $gender }}</span> </li>
    <li style="font-size: 16px;">Permanent Address : <span style="padding-left: 20px;">{{ $paddress }}</span> </li>
    <li style="font-size: 16px;">Temporary Address : <span style="padding-left: 20px;">{{ $taddress }}</span> </li>
    <li style="font-size: 16px;">Education : <span style="padding-left: 20px;">{{ $education }}</span> </li>
    <li style="font-size: 16px;">Experience : <span style="padding-left: 20px;">{{ $experience }}</span> </li>
    <li style="font-size: 16px;">About Applicant : <span style="padding-left: 20px;">{{ $message }}</span> </li>
</ul>
@isset($resume)
<?php
    $color = 'primary';
?>
@component('mail::button', ['url' => $resume, 'color' => $color])
Download Resume
@endcomponent
@endisset
</p>


{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent