@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Hello !</h1>
<p>
    We'd like to inform you that a new product enquiry has been submitted through our website. Here are the enquiry details:
</p>
<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Personal Details</strong> </span> </li>
    <li style="font-size: 16px;">Full Name : <span style="padding-left: 20px;">{{ $name }}</span> </li>
    <li style="font-size: 16px;">Email : <span style="padding-left: 20px;text-transform: lowercase;">{{ $email }}</span> </li>
    <li style="font-size: 16px;">Phone : <span style="padding-left: 20px;">{{ $phone }}</span> </li>
    <li style="font-size: 16px;">Address : <span style="padding-left: 20px;">{{ $address }}</span> </li>
    @isset($companyName)
    <li style="font-size: 16px;">Company Name : <span style="padding-left: 20px;">{{ $companyName }}</span> </li>
    @endisset
</ul>

</p>

<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Product Details</strong> </span> </li>
    <li style="font-size: 16px;">Product Name: : <span style="padding-left: 20px;text-transform: lowercase;">{{ $productName }}</span> </li>
    <li style="font-size: 16px;">Remarks : <span style="padding-left: 20px;">{{ $remarks }}</span> </li>
</ul>

</p>

<p>
    Please review the provided information and take the necessary steps to address this product inquiry. Your timely response to this matter is important.
</p>


{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent