@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    Thank you for expressing interest in becoming a dealer for {{ config('app.name') }}. We appreciate your desire to partner with us and explore potential business opportunities.
</p>
<p>
    Your interest in becoming a dealer is important to us, and we're excited to learn more about your business and how we can collaborate. We recognize the value you can bring to our products and services.
</p>
<p>
    Could you please provide us with more information about your dealership and your business model? This will help us understand your business better and evaluate how we can work together effectively.
</p>
<p>
    Rest assured that we have received your dealer application and are reviewing it with care. We'll be in touch as soon as we've completed our evaluation and have more information to share.
</p>
<p>
    If you have any additional information to share or if you think of any more details that might help us, please feel free to include them in your reply to this email.
</p>
<p>
    In the meantime, if you have any additional information to provide or any specific questions, please feel free to include them in your response to this email.
</p>
<p>
    Thank you once again for considering a partnership with {{ config('app.name') }}. We're enthusiastic about the prospect of working together and growing our businesses.
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent