@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    We want to express our sincere gratitude for taking the time to apply for the {{ $jobTitle }} position at {{ config('app.name') }}. We appreciate your interest in joining our team and considering us as part of your career journey.
</p>
<p>
    While we go through the selection process, we encourage you to learn more about {{ config('app.name') }} and our values by exploring our website and social media channels.
</p>
<p>
    Once again, thank you for your application. We value the opportunity to connect with professionals like you and look forward to potentially discussing how your background aligns with our team's needs.
</p>
<p>
    If you have any questions or need further information, please don't hesitate to contact us at [{{ get_option('email') . ' or ' . get_option('mobile_phone_first') }}].
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent