@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    Thank you for bringing your concerns to our attention. We sincerely apologize for any inconvenience you've experienced and appreciate the opportunity to address your complaint.
</p>
<p>
    Your feedback is invaluable to us, as it helps us improve our products and services. We take your concerns seriously and are committed to resolving the issue to your satisfaction.
</p>
<p>
    Would you please provide us with more details about the specific nature of your complaint? This will help us understand the situation better and allow us to address the issue more effectively.
</p>
<p>
    Rest assured that your complaint has our full attention, and we're working diligently to investigate and find a solution. We'll get back to you as soon as we have more information and a plan for resolution.
</p>
<p>
    If you have any additional information to share or if you think of any more details that might help us, please feel free to include them in your reply to this email.
</p>
<p>
    Thank you for your patience as we work to address your concerns. We value your feedback and are committed to ensuring a positive experience for you as our valued customer.
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent