@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    Thank you for expressing interest in becoming a dealer with {{ config('app.name') }}. We appreciate your desire to partner with us and explore potential business opportunities.
</p>
<p>
    We understand that becoming a dealer involves important considerations, and we're excited to learn more about how we can collaborate. Our team values the potential of this partnership and the value you can bring to our products and services.
</p>
<p>
    Could you please provide us with more details about your business, including the products you currently deal with and any other relevant information? This will help us understand your business better and how we can work together effectively.
</p>
<p>
    We look forward to learning more about your business and exploring the possibilities of a successful partnership. If you have any questions or need further information, please don't hesitate to reach out.
</p>
<p>
    Thank you once again for your interest in joining {{ config('app.name') }} as a dealer. We're excited about the prospect of working together and growing our businesses.
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent