@extends('layouts.frontend.main')


@section('headerTitle', 'About Us')

@section('title', get_seo_page('about-us')->seo_title ?? 'About Us')

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('about-us')->seo_title ?? 'About Us - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('about-us')->seo_title ?? 'About Us - ' . get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('header')
    <li class="breadcrumb-item active">About Us</li>
@endsection

@section('styles')
    <link rel="stylesheet" href="/frontend/css/service-compare.css">
@endsection

@section('content')
    <h1 class="d-none">{{ get_seo_page('about-us')->seo_title ?? 'About Us - ' . get_option('title') }}</h1>
    <!--About One Start -->
    @include('frontend.partials.about-box')
    <!--About One End -->


    <!--Start Testimonial One-->
    @include('frontend.partials.testimonial-box')

@endsection

@section('scripts')
    <script src="/frontend/js/jquery.event.move.js"></script>
    <script src="/frontend/js/jquery.twentytwenty.js"></script>
    <script>
        if ($('.transformation_image').length) {
            $(".transformation_image").twentytwenty({
                no_overlay: true,
            });
        }
    </script>
@endsection
