@extends('layouts.frontend.main')

@section('title', $joblist->title)

@section('headerTitle', $joblist->title)

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('career.index') }}">Career</a> </li>
    <li class="breadcrumb-item active">{{ $joblist->title }}</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="Vacancy for {{ $joblist->title }} - {{ get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="Vacancy for {{ $joblist->title }} - {{ get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection


@section('styles')
    <link rel='stylesheet'
        href='https://cdn-uicons.flaticon.com/3.0.0/uicons-regular-rounded/css/uicons-regular-rounded.css'>
    <style>
        .services-details__content-text1 ul {
            list-style-type: disc;
            padding-left: 16px;
        }
    </style>
@endsection

@section('content')
    <h1 class="d-none">{{ $joblist->title }}</h1>
    <section class="sidebar-page-container left-sidebar">
        <div class="container">
            <div class="row clearfix">
                <!--Start Services Details Sidebar-->

                <!--End Services Details Sidebar-->
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar">

                        <div class="project-widget">
                            <ul class="project-detail_info">
                                <li>
                                    <i class="fi fi-rr-users"></i>
                                    Job Title:
                                    <span>{{ $joblist->title }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-folder-tree"></i>
                                    Employment Type:
                                    <span>{{ $joblist->time }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-clock-five"></i>
                                    No. of Vacancy:
                                    <span>{{ $joblist->no_of_vacancy }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-graduation-cap"></i>
                                    Education:
                                    <span>{{ $joblist->education }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-flask-potion"></i>
                                    Experience:
                                    <span>{{ $joblist->experince }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-payroll"></i>
                                    Salary:
                                    <span>{{ $joblist->salary }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-calendar"></i>
                                    Deadline:
                                    <span>{{ $joblist?->deadline?->format('d M, Y') ?? '-' }}</span>
                                </li>
                            </ul>
                        </div>

                    </aside>
                </div>
                <!--Start Services Details Content-->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="service-detail service__detail">
                        <h2 class="service-detail_title">{{ $joblist->title }}</h2>

                        {!! $joblist->description !!}


                        <div class="about-one_button">
                            <a href="{{ route('career.apply', $joblist) }}" class="theme-btn btn-style-one">
                                <span class="btn-wrap">
                                    <span class="text-one">Apply Now</span>
                                    <span class="text-two">Apply Now</span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
                <!--End Services Details Content-->
            </div>
        </div>
    </section>

@endsection

@section('scripts')
    <script>
        $(".service__detail li").each(function() {
            if (!$(this).find(".flaticon-checked").length) {
                $(this).prepend('<i class="flaticon-checked"></i> ');
            }
        });
    </script>
@endsection
