@extends('layouts.frontend.main')

@section('headerTitle', 'Events')

@section('title', get_seo_page('events')->seo_title ?? 'Events')

@section('meta')
    <meta name="keywords" content="{{ get_seo_page('events')->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('events')->seo_title ?? 'Events - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('events')->seo_title ?? 'Events - ' . get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('header')
    <li class="breadcrumb-item active">Events</li>
@endsection

@section('content')
    <h1 class="d-none">{{ get_seo_page('events')->seo_title ?? 'Events - ' . get_option('title') }}</h1>
    <section class="team-one">
        <div class="container">
            <div class="row">

                @foreach ($events as $item)
                    <!--Start Team One Single-->
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="team-one__single">
                            <div class="team-one__img-box">
                                <a href="{{ route('event.show', $item) }}" class="team-one__img">
                                    <img src="{{ $item->imageUrl }}" alt="{{ $item->title }}">
                                </a>
                            </div>

                            <div class="team-one__content">
                                <h3 class="team-one__title">
                                    <a href="{{ route('event.show', $item) }}">
                                        {{ $item->title }}
                                    </a>
                                </h3>
                                <p class="team-one__sub-title">{{ $item->location }}</p>

                            </div>
                        </div>
                    </div>
                    <!--End Team Two Single-->
                @endforeach


            </div>
        </div>
    </section>
@endsection
