@extends('layouts.frontend.main')

@section('title', $event->seo_title ?? $event->title)

@section('headerTitle', $event->title)

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('event.index') }}">Events</a></li>
    <li><span class="icon-right-arrow"></span></li>
    <li class="breadcrumb-item active" aria-current="page">{{ $event->title }}</li>
@endsection


@section('meta')
    <meta name="keywords" content="{{ $event->seo_keyword ?? get_option('seo_meta_keywords') }} }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ $event->seo_title ?? $event->title }} - {{ get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/events/' . $event->image) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ $event->seo_title ?? $event->title }} - {{ get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/events/' . $event->image) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <h1 class="d-none">{{ $event->seo_title ?? $event->title }} - {{ get_option('title') }}</h1>
    <section class="services-details">
        <div class="container">
            <div class="row justify-content-center">


                <!--Start Services Details Content-->
                <div class="col-xl-9">
                    <div class="services-details__content">
                        <div class="services-details__content-img">
                            <section class="main-slider">
                                <div class="swiper-container event-slider__carousel">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <img src="{{ $event->imageUrl }}" alt="{{ $event->title }}">
                                        </div>
                                        @if (count(json_decode($event->images) ?? []))
                                            @foreach (json_decode($event->images) as $item)
                                                <div class="swiper-slide">
                                                    <img src="/frontend/images/events/{{ $item }}" alt="">
                                                </div>
                                            @endforeach

                                        @endif

                                    </div>
                                    <!-- If we need navigation buttons -->
                                </div>


                            </section>
                        </div>

                        <div class="services-details__content-text1">
                            <div class="title-box">
                                <h2 class="fs-3">{{ $event->title }}</h2>
                                <p>{{ $event->location }}</p>
                            </div>

                            <p class="text1">
                                {!! $event->description !!}
                            </p>


                        </div>


                        <div class="blog-details__content-text3">

                            <div class="blog-details__content-text3-share">
                                <div class="title-box">
                                    <h2>Share:</h2>
                                </div>

                                <ul>
                                    <li>
                                        <a href="https://facebook.com/sharer/sharer.php?u={{ request()->url() }}">
                                            <span class="icon-facebook-app-symbol"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://twitter.com/intent/tweet?text={{ $event->title }}&url={{ request()->url() }}">
                                            <span class="icon-twitter-1"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://www.linkedin.com/shareArticle?url={{ request()->url() }}&title={{ $event->title }}">
                                            <span class="icon-linkedin-big-logo"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://www.pinterest.com/pin/create/button?url={{ $event->title }}&media={{ $event->imageUrl }}&description={{ $event->title }}">
                                            <span class="icon-pinterest"></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
                <!--End Services Details Content-->
            </div>
        </div>
    </section>
@endsection
