@extends('layouts.frontend.main')

@section('title', get_seo_page('location')->seo_title ?? 'Our Presence')

@section('headerTitle', 'Our Presence')

@section('header')
    <li class="breadcrumb-item active">Our Presence</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_seo_page('location')->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_seo_page('location')->seo_description ?? get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="{{ get_seo_page('location')->seo_title ?? 'Our Presence - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('location')->seo_description ?? get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title"
        content="{{ get_seo_page('location')->seo_title ?? 'Our Presence - ' . get_option('title') }}">
    <meta name="og:description"
        content="{{ get_seo_page('location')->seo_description ?? get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <h1 class="d-none">{{ get_seo_page('location')->seo_title ?? 'Our Presence - ' . get_option('title') }}</h1>
    <!--Start Pricing One-->
    <section class="pricing-one pricing-one--pricing">
        <div class="container">
            <div class="sec-title sec-title-animation animation-style1">

                <h3 class="map-one_title">Our Presence</h3>
                <div class="map-one_text mt-1">We are a trusted supplier of premium building materials in Nepal, <br>
                    supporting
                    residential, commercial, and hospitality projects with quality, <br> innovation, and reliable solutions.
                </div>
            </div>
            <div class="row g-4">
                <!--Start Pricing One Single-->
                @foreach (get_locations() as $item)
                    <div class="team-block_one col-lg-4 col-md-12 col-sm-12">
                        <div class="team-block_one-inner">
                            <div class="team-block_one-pattern"
                                style="background-image:url(assets/images/background/pattern-9.png)"></div>
                            <div class="team-block_one-content pt-0" style="min-height: auto">

                                <h4 class="team-block_one-heading">
                                    <a href="#">{{ $item->title }}</a>
                                </h4>
                            </div>
                        </div>
                    </div>
                @endforeach
                <!--End Pricing One Single-->

            </div>
        </div>
    </section>
    <!--End Pricing One-->
@endsection
