@extends('layouts.frontend.main')

@section('title', get_seo_page('store')->seo_title)

@section('headerTitle', get_seo_page('store')->seo_title)

@section('header')
    <li class="breadcrumb-item active">Products</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_seo_page('store')->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_seo_page('store')->seo_description ?? get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('store')->seo_title ?? 'Product Store - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('store')->seo_description ?? get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('store')->seo_title ?? 'Product Store - ' . get_option('title') }}">
    <meta name="og:description"
        content="{{ get_seo_page('store')->seo_description ?? get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <!-- Shop One -->
    <section class="shop-two">
        <div class="container">
            <div class="row clearfix">

                @foreach ($products as $item)
                    <!-- Shop Block One -->
                    <div class="shop-block_one col-lg-3 col-md-6 col-sm-6">
                        <div class="shop-block_one-inner h-100">
                            <div class="shop-block_one-image">
                                <a href="{{ route('product.show', $item) }}">
                                    <img src="{{ $item->imageUrl }}" alt="{{ $item->title }}" />
                                </a>
                            </div>
                            <div class="shop-block_one-content">
                                <h4 class="shop-block_one-heading">
                                    <a href="{{ route('product.show', $item) }}">{{ $item->title }}</a>
                                </h4>
                            </div>
                        </div>
                    </div>
                @endforeach



            </div>

            <!-- Styled Pagination -->
            {{ $products->links() }}

            <!-- End Styled Pagination -->

        </div>
    </section>
    <!-- End Shop One -->


@endsection
