@extends('layouts.frontend.main')

@section('title', $product->seo_title ?? $product->title)

@section('headerTitle', $product->title)


@section('header')
    <li> <a href="{{ route('product.index') }}">Products</a> </li>

    <li class="breadcrumb-item active">{{ $product->title }}</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ $product->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ $product->seo_description ?? $product->summary }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ $product->seo_title ?? $product->title }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/products/' . $product->image) }}">
    <meta name="twitter:description" content="{{ $product->seo_description ?? $product->summary }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ $product->seo_title ?? $product->title }}">
    <meta name="og:description" content="{{ $product->seo_description ?? $product->summary }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/products/' . $product->image) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('styles')
    <link rel="stylesheet" href="/frontend/css/custom.css">
    <style>
        .highlight-one__single-img {
            height: 320px;
        }

        .highlight-one__single-content h2 a {
            font-size: 20px
        }

        .page-header {
            padding: 30px 0px 40px
        }
    </style>
@endsection

@section('content')
    <h1 class="d-none">{{ $product->seo_title ?? $product->title }}</h1>
    <section class="shop-detail">
        <div class="auto-container">

            <div class="row clearfix">
                <!-- Gallery Column -->
                <div class="shop-detail_gallery-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <div class="carousel-outer">
                            <!-- Swiper -->
                            <div class="swiper-container content-carousel">
                                <div class="swiper-wrapper">

                                    <div class="swiper-slide">
                                        <figure class="image">
                                            <a href="{{ $product->imageUrl }}" class="lightbox-image">
                                                <img src="{{ $product->imageUrl }}" alt="{{ $product->title }}">
                                            </a>
                                        </figure>
                                    </div>
                                    @if ($product?->images)
                                        @if (count(json_decode($product?->images)))
                                            @foreach (json_decode($product?->images) as $item)
                                                <div class="swiper-slide">
                                                    <figure class="image">
                                                        <a href="/frontend/images/products/{{ $item }}"
                                                            class="lightbox-image">
                                                            <img src="/frontend/images/products/{{ $item }}"
                                                                alt="{{ $product->title }}">
                                                        </a>
                                                    </figure>
                                                </div>
                                            @endforeach
                                        @endif
                                    @endif
                                </div>
                            </div>

                            <div class="swiper-container thumbs-carousel">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <figure class="thumb">
                                            <img class="h-100 w-100" src="{{ $product->imageUrl }}"
                                                alt="{{ $product->title }}">
                                        </figure>
                                    </div>
                                    @if ($product?->images)
                                        @if (count(json_decode($product?->images)))
                                            @foreach (json_decode($product?->images) as $item)
                                                <div class="swiper-slide">
                                                    <figure class="thumb">
                                                        <img class="h-100 w-100"
                                                            src="/frontend/images/products/{{ $item }}"
                                                            alt="{{ $product->title }}">
                                                    </figure>
                                                </div>
                                            @endforeach
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Content Column -->
                <div class="shop-detail_content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <h3 class="shop-detail_title">{{ $product->title }}</h3>
                        <!-- Rating -->

                        <div class="shop-detail_text">
                            {{ $product->summary }}
                        </div>

                        <ul class="shop-detail_list alternate">
                            <li>
                                <i class="flaticon-check-mark"></i>
                                <strong>Category:</strong> {{ $product?->category?->title }}
                            </li>
                        </ul>
                        <div class="d-flex align-items-center flex-wrap">

                            <!-- Button Box -->
                            <div class="button-box ms-0">
                                <button type="button" data-bs-toggle="modal" data-bs-target="#enquiry"
                                    class="theme-btn btn-style-one">
                                    <span class="btn-wrap">
                                        <span class="text-one">Enquiry Now</span>
                                        <span class="text-two">Enquiry Now</span>
                                    </span>
                                </button>
                            </div>
                        </div>
                        <!-- Socials -->
                        <div class="shop-detail_socials">
                            <span>Share:</span>
                            <a class="fa-brands fa-facebook-f fa-fw"
                                href="https://facebook.com/sharer/sharer.php?u={{ request()->url() }}"></a>
                            <a class="fa-brands fa-twitter fa-fw"
                                href="https://twitter.com/intent/tweet?text={{ $product->title }}&url={{ request()->url() }}"></a>
                            <a class="fa-brands fa-linkedin fa-fw"
                                href="https://www.linkedin.com/shareArticle?url={{ request()->url() }}&title={{ $product->title }}"></a>
                            <a class="fa-brands fa-pinterest fa-fw"
                                href="https://www.pinterest.com/pin/create/button?url={{ $product->title }}&media={{ $product->imageUrl }}&description={{ $product->title }}"></a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lower Box -->
            <div class="lower-box">

                <!-- Product Info Tabs -->
                <div class="product-info-tabs">
                    <!-- Product Tabs -->
                    <div class="prod-tabs tabs-box">

                        <!-- Tab Btns -->
                        <ul class="tab-btns tab-buttons clearfix">
                            <li data-tab="#prod-info" class="tab-btn active-btn">Description</li>
                            <li data-tab="#prod-specifications" class="tab-btn">Specifications</li>
                        </ul>

                        <!-- Tabs Container -->
                        <div class="tabs-content">

                            <!-- Tab -->
                            <div class="tab active-tab" id="prod-info">
                                <div class="content">
                                    {!! $product->description !!}
                                </div>
                            </div>

                            <!-- Tab -->
                            <div class="tab" id="prod-specifications">
                                <div class="content">
                                    {!! $product->specification !!}
                                </div>
                            </div>

                            <!--Tab-->


                        </div>
                    </div>

                </div>
                <!--End Product Info Tabs-->

            </div>
            <!-- End Lower Box -->

            @if (get_products_by_category($product?->category?->title))
                <!-- Related Products -->
                <div class="related-products">
                    <h3>Related Products</h3>
                    <div class="row clearfix">

                        @foreach (get_products_by_category($product?->category?->title)->except($product->id)->take(3) as $item)
                            <!-- Shop Block One -->
                            <div class="shop-block_one col-lg-4 col-md-6 col-sm-6">
                                <div class="shop-block_one-inner">
                                    <div class="shop-block_one-image">
                                        <a href="{{ route('product.show', $item) }}">
                                            <img src="{{ $item->imageUrl }}" alt="{{ $item->title }}" />
                                        </a>
                                    </div>
                                    <div class="shop-block_one-content">
                                        <h4 class="shop-block_one-heading">
                                            <a href="{{ route('product.show', $item) }}">
                                                {{ $item->title }}
                                            </a>
                                        </h4>

                                    </div>
                                </div>
                            </div>
                        @endforeach


                    </div>
                </div>
            @endif

        </div>
    </section>




    <style>
        .custom-close-btn {
            border: 1px solid white;
            padding: 10px;
            height: 38px;
            width: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50rem;
            color: white;
            background: linear-gradient(135deg, #7b2f8e 0%, #8e2c7c 50%, #b11f5a 100%);
        }

        .contact-page__form-title {
            font-size: 32px
        }
    </style>

    <!-- Enquiry-from -->
    <div class="modal fade" id="enquiry">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content contact-page__inner p-0">

                <div class="modal-body p-5">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h3 class="contact-page__form-title mb-0">Get A Quote</h3>

                        <button type="button" class="custom-close-btn" data-bs-dismiss="modal" aria-label="Close">
                            <i class="fas fa-times"></i>
                        </button>

                    </div>

                    <div class="contact-form">

                        <form id="contact-form" class=" contact-page__form"
                            action="{{ route('product.store', $product) }}" method="POST">
                            @csrf

                            <div class="row">
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" name="first_name" value="{{ old('first_name') }}"
                                            placeholder="Your First name" required="" />
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" name="last_name" value="{{ old('last_name') }}"
                                            placeholder="Your Last name" required="" />
                                    </div>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="email" name="email" value="{{ old('email') }}"
                                            placeholder="Your Email" required="" />
                                    </div>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" name="phone_number" value="{{ old('phone_number') }}"
                                            placeholder="Phone Number" required="" />
                                    </div>
                                </div>

                                <div class="col-xl-12 col-lg-12 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" placeholder="Your Address" value="{{ old('address') }}"
                                            name="address" />
                                    </div>
                                </div>

                                <div class="col-xl-12 form-group">
                                    <div class="contact-page__input-box text-message-box">
                                        <textarea name="remarks" placeholder="If any query">{{ old('remarks') }}</textarea>
                                    </div>
                                </div>

                                <div class="cta-one__btn become__a_dealer">
                                    <button type="submit" class="theme-btn btn-style-one">
                                        <span class="btn-wrap">
                                            <span class="text-one">Send Message</span>
                                            <span class="text-two">Send Message</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Enquiry-form -->
@endsection
