@extends('layouts.frontend.main')


@section('headerTitle', 'Videos')

@section('title', get_seo_page('videos')->seo_title ?? 'Videos')

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('videos')->seo_title ?? 'Videos - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('videos')->seo_title ?? 'Videos - ' . get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('header')
    <li class="breadcrumb-item active">Videos</li>
@endsection

@section('styles')
    <style>
        .team-one__single {
            height: 100%;
        }

        #html5-watermark {
            display: none !important;
        }

        .team-one__img::after {
            /* display: none; */
            opacity: 1;
            background-color: rgba(var(--suntop-black-rgb), 0.2);
        }

        .team-one__content {
            margin: 0;
        }

        .team-one__img {
            background-color: rgba(23, 23, 23, 0.4);
        }


        .team-one__single .team-one__content::before {
            transform: scaleY(1);
        }

        .team-one__single .team-one__content::after {
            transform: scaleY(1);
        }


        .videos-product__video-link {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .videos-product__video-icon {
            position: relative;
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
            width: 70px;
            height: 70px;
            line-height: 70px;
            text-align: center;
            font-size: 17px;
            color: var(--suntop-base);
            background-color: rgba(var(--suntop-white-rgb), 0.3);
            border-radius: 50%;
            transition: all 0.5s ease;
            -moz-transition: all 0.5s ease;
            -webkit-transition: all 0.5s ease;
            -ms-transition: all 0.5s ease;
            -o-transition: all 0.5s ease;
            z-index: 099999999;
        }

        .videos-product__video-icon:hover {
            color: var(--suntop-white);
        }

        .videos-product__video-icon:before {
            position: absolute;
            top: 10px;
            left: 10px;
            right: 10px;
            bottom: 10px;
            background-color: var(--suntop-white);
            border-radius: 50%;
            content: "";
            transition: all 0.5s ease;
            -moz-transition: all 0.5s ease;
            -webkit-transition: all 0.5s ease;
            -ms-transition: all 0.5s ease;
            -o-transition: all 0.5s ease;
            z-index: -1;
        }

        .videos-product__video-icon:hover::before {
            background-color: var(--suntop-base);
        }

        .videos-product__video-link .ripple,
        .videos-product__video-icon .ripple:before,
        .videos-product__video-icon .ripple:after {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 75px;
            height: 75px;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            -ms-box-shadow: 0 0 0 0 rgba(var(--suntop-white-rgb), 0.3);
            -o-box-shadow: 0 0 0 0 rgba(var(--suntop-white-rgb), 0.3);
            -webkit-box-shadow: 0 0 0 0 rgba(var(--suntop-white-rgb), 0.3);
            box-shadow: 0 0 0 0 rgba(var(--suntop-white-rgb), 0.3);
            -webkit-animation: ripple 3s infinite;
            animation: ripple 3s infinite;
            border-radius: 50%;
        }

        .videos-product__video-icon .ripple:before {
            -webkit-animation-delay: 0.9s;
            animation-delay: 0.9s;
            content: "";
            position: absolute;
        }

        .videos-product__video-icon .ripple:after {
            -webkit-animation-delay: 0.6s;
            animation-delay: 0.6s;
            content: "";
            position: absolute;
        }

        .team-one__content {
            height: calc(100% - 320px);
        }
    </style>
@endsection

@section('content')
    <h1 class="d-none">{{ get_seo_page('videos')->seo_title ?? 'Videos - ' . get_option('title') }}</h1>
    <section class="team-one">
        <div class="container">
            <div class="row">

                @foreach ($videos as $item)
                    @php
                        $videoURL = $item->link;
                        // Extract YouTube ID
                        preg_match('/(?:v=|\/)([0-9A-Za-z_-]{11})/', $videoURL, $matches);
                        $youtubeVideoId = $matches[1] ?? null;

                        $embedURL = 'https://www.youtube.com/embed/' . $youtubeVideoId;
                        $thumbURL = 'https://img.youtube.com/vi/' . $youtubeVideoId . '/0.jpg';

                    @endphp
                    <!--Start Team One Single-->
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="team-one__single">
                            <div class="team-one__img-box">
                                <div class="team-one__img">
                                    <img src="{{ $thumbURL }}" alt="{{ $item->title }}" />
                                </div>
                                <div class="videos-product__video-link">
                                    <a href="{{ $embedURL }}" class="html5lightbox" title="{{ $item->title }}">
                                        <div class="videos-product__video-icon">
                                            <span class="fa fa-play"></span>
                                            <i class="ripple"></i>
                                        </div>
                                    </a>
                                </div>
                            </div>

                            <div class="team-one__content">
                                <h3 class="team-one__title" style="line-height: 1.1; ">
                                    <a href="{{ $embedURL }}" class="fs-5"
                                        style="font-weight: 500; line-height: 1.1; ">
                                        {{ $item->title }}
                                    </a>
                                </h3>
                            </div>
                        </div>
                    </div>
                    <!--End Team Two Single-->
                @endforeach

            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script src="/html5lightbox/html5lightbox.js"></script>
@endsection
