<?php $__env->startSection('title', $blog->seo_title ?? $blog->title); ?>

<?php $__env->startSection('headerTitle', $blog->title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('blog.index')); ?>">Blogs</a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($blog->title); ?></li>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($blog->seo_keyword ?? get_option('seo_meta_keywords')); ?> ">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($blog->seo_title ?? $blog->title); ?> }}">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/blogs/' . $blog->image)); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($blog->seo_title ?? $blog->title); ?> }}">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/blogs/' . $blog->image)); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($blog->seo_title ?? $blog->title); ?></h1>

    <div class="sidebar-page-container">
        <div class="container">
            <div class="row clearfix">

                <!-- Content Side -->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="blog-detail">
                        <div class="blog-detail_inner">
                            <div class="blog-detail_image">
                                <img src="<?php echo e($blog->imageUrl); ?>" alt="<?php echo e($blog->title); ?>" />
                                <div class="blog-detail_content">
                                    <ul class="blog-detail_meta">
                                        <li>
                                            <span class="icon fa fa-user"></span>By Admin
                                        </li>
                                        <li>
                                            <span class="icon fa fa-calendar"></span>
                                            <?php echo e($blog?->created_at?->format('d M, Y')); ?>

                                        </li>
                                    </ul>
                                    <h3 class="blog-detail_heading"><?php echo e($blog->title); ?></h3>
                                    <div class="blog-detail-description">
                                        <?php echo $blog->description; ?>

                                    </div>


                                    <!-- Post Share Options-->
                                    <div class="post-share-options">
                                        <div class="post-share-inner d-flex justify-content-between flex-wrap">
                                            <div class="post-tags">
                                                <span>Share on:</span>
                                                <div class="footer_socials d-inline-block">
                                                    <a class="fa-brands p-0 fa-facebook-f fa-fw"
                                                        href="https://facebook.com/sharer/sharer.php?u=<?php echo e(request()->url()); ?>"></a>
                                                    <a class="fa-brands p-0 fa-twitter fa-fw"
                                                        href="https://twitter.com/intent/tweet?text=<?php echo e($blog->title); ?>&url=<?php echo e(request()->url()); ?>"></a>
                                                    <a class="fa-brands p-0 fa-linkedin fa-fw"
                                                        href="https://www.linkedin.com/shareArticle?url=<?php echo e(request()->url()); ?>&title=<?php echo e($blog->title); ?>"></a>
                                                    <a class="fa-brands p-0 fa-pinterest fa-fw"
                                                        href="https://www.pinterest.com/pin/create/button?url=<?php echo e($blog->title); ?>&media=<?php echo e($blog->imageUrl); ?>&description=<?php echo e($blog->title); ?>"></a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- Sidebar Side -->
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar">

                        <!-- Search Widget -->
                        <div class="sidebar-widget search-box">
                            <div class="widget-content">
                                <h5 class="sidebar-widget_title">Search</h5>
                                <form method="get" action="/blogs">
                                    <div class="form-group">
                                        <input type="search" name="search" placeholder="Search" required>
                                        <button type="submit"><span class="icon fa fa-search"></span></button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Categories Widget -->
                        <div class="sidebar-widget categories-widget">
                            <div class="widget-content">
                                <h5 class="sidebar-widget_title">Categories</h5>
                                <ul class="service-list_two">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('blog_category.show', $item)); ?>">
                                                <?php echo e($item->title); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>

                        <!-- Post Widget -->
                        <div class="sidebar-widget post-widget">
                            <div class="widget-content">
                                <h5 class="sidebar-widget_title">Recent News</h5>

                                <?php $__currentLoopData = $blogs->except($blog->id)->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="post">
                                        <div class="thumb">
                                            <a href="<?php echo e(route('blog.show', $item)); ?>">
                                                <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                                            </a>
                                        </div>
                                        <div class="post-date"><?php echo e($item?->created_at?->format('d M, Y')); ?></div>
                                        <h6>
                                            <a href="<?php echo e(route('blog.show', $item)); ?>">
                                                <?php echo e($item->title); ?>

                                            </a>
                                        </h6>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>


                    </aside>
                </div>

            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/blogs/blog-show.blade.php ENDPATH**/ ?>