<?php
    $title = get_seo_page('blogs')->seo_title ?? 'Blogs';
    $seoTitle = get_seo_page('blogs')->seo_title ?? 'Blogs - ' . get_option('title');

    if ($searchText) {
        $title = $blogs->count() . ' Blogs by ' . $searchText;
        $seoTitle = $blogs->count() . ' ' . $title . ' ' . get_option('title');
    }
?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active" aria-current="page">
        Blogs & News
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('headerTitle', $title); ?>

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('blogs')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_seo_page('blogs')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($seoTitle); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('blogs')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($seoTitle); ?>">
    <meta name="og:description"
        content="<?php echo e(get_seo_page('blogs')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($seoTitle); ?></h1>

    <!-- Blog Three -->
    <section class="blog-three">
        <div class="container">
            <div class="row clearfix">

                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- News Block Two -->
                    <div class="news-block_two col-lg-4 col-md-6 col-sm-12">
                        <div class="news-block_two-inner h-100">
                            <div class="news-block_two-image">
                                <a href="<?php echo e(route('blog.show', $item)); ?>">
                                    <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>" />
                                </a>
                            </div>
                            <div class="news-block_two-content">
                                <div class="news-block_two-title"><?php echo e($item?->category?->title); ?></div>
                                <h5 class="news-block_two-heading">
                                    <a href="<?php echo e(route('blog.show', $item)); ?>">
                                        <?php echo e($item->title); ?>

                                    </a>
                                </h5>
                                <ul class="news-block_two-meta">
                                    <li>
                                        <span class="icon fa fa-user"></span>By Admin
                                    </li>
                                    <li>
                                        <span class="icon fa fa-calendar"></span>
                                        <?php echo e($item?->created_at?->format('d M, Y')); ?>

                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php echo e($blogs->links()); ?>

            </div>
        </div>
    </section>
    <!-- End Blog Three -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/blogs/blog-index.blade.php ENDPATH**/ ?>