<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('categories.index')); ?>">Category List</a></li>
    <li class="breadcrumb-item active">Category Form</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title mb-0">Category Form</div>
                    <!-- .step-fields -->
                </div>
                <div class="card-body">
                    <form enctype="multipart/form-data" action="<?php echo e(route('categories.update', $category)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>
                        <div class="row g-3">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label class="form-label">
                                        Category Name <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="title" type="text" name="title"
                                        value="<?php echo e(old('title', $category->title)); ?>">
                                </div>
                                <!-- .input-item -->
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">
                                        Slug <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control" id="slug" type="text" name="slug"
                                        value="<?php echo e(old('slug', $category->slug)); ?>">
                                </div>
                                <!-- .input-item -->
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Category Image</label>
                                    <input type="file" data-value="<?php echo e($category->image); ?>" readonly name="image"
                                        class="form-control appsvan-file">
                                </div>
                                <!-- .input-item -->
                            </div>
                            <?php if($category->parent_category != null): ?>

                                <?php if(get_first_category($category->parent_category) != null &&
                                        get_first_category($category->parent_category)->parent_category): ?>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">
                                                Parent Category
                                            </label>
                                            <select name="parent_category" onchange="getData(this.value);"
                                                class="form-control select2">
                                                <option value="">Select One</option>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php echo e(old('parent_category', get_first_category($category->parent_category)->parent_category) == $data->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($data->id); ?>"><?php echo e($data->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <!-- .input-item -->
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">
                                                Sub Category
                                            </label>
                                            <select name="subcategory_id" onchange="getSubCategory(this.value)"
                                                class="form-control select2">
                                                <option value="">Select One</option>
                                                <?php $__currentLoopData = get_sub_categories(get_first_category($category->parent_category)->parent_category); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php echo e(old('subcategory_id', $category->parent_category) == $subcategory->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($subcategory->id); ?>">
                                                        <?php echo e($subcategory->title); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <!-- .input-item -->
                                    </div>

                                    <div class="col-md-4 student-group1">
                                        <div class="form-group col-md-12">
                                            <label class="form-label">Child Category <span
                                                    class="text-danger">*</span></label>
                                            <select name="childsubcategory_id" class="form-control select2">
                                                <option value="">Select One</option>
                                                <?php $__currentLoopData = get_sub_categories($category->parent_category)->except($category->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php echo e(old('childsubcategory_id', $category->id) == $childcategory->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($childcategory->id); ?>">
                                                        <?php echo e($childcategory->title); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="col-md-4">
                                        <div class="form-group col-md-12">
                                            <label class="form-label">Parent Category <span
                                                    class="text-danger">*</span></label>
                                            <select name="parent_category" class="form-control select2"
                                                onchange="getData(this.value);">
                                                <option value="">Select One</option>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php echo e(old('parent_category', $category->parent_category) == $data->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($data->id); ?>">
                                                        <?php echo e($data->title); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4 student-group">
                                        <div class="form-group col-md-12">
                                            <label class="form-label">Sub Category <span
                                                    class="text-danger">*</span></label>
                                            <select name="subcategory_id" class="form-control select2"
                                                onchange="getSubCategory(this.value)">
                                                <option value="">Select One</option>
                                                <?php $__currentLoopData = get_sub_categories($category->parent_category)->except($category->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php echo e(old('subcategory_id', $category->id) == $subcategory->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($subcategory->id); ?>">
                                                        <?php echo e($subcategory->title); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">
                                            Parent Category
                                        </label>
                                        <select name="parent_category" onchange="getData(this.value);"
                                            class="form-control select2">
                                            <option value="">Select One</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e(old('parent_category') == $data->id ? 'selected' : ''); ?>

                                                    value="<?php echo e($data->id); ?>"><?php echo e($data->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <!-- .input-item -->
                                </div>
                                <div class="col-md-4 student-group">
                                    <div class="form-group ">
                                        <label class="form-label">Sub Category</label>
                                        <select name="subcategory_id" class="form-control select2"
                                            onchange="getSubCategory(this.value)">
                                            <option value="">Select One</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 student-group1">
                                    <div class="form-group">
                                        <label class="form-label">Select Child Category:</label>
                                        <select name="childsubcategory_id" class="form-control select2">
                                            <option value="">Select One</option>
                                        </select>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Status <span class="text-danger">*</span> </label>
                                    <select class="form-control select2" name="status" required>
                                        <option value="">Select One</option>
                                        <option <?php echo e(old('status', $category->status) == '1' ? 'selected' : ''); ?>

                                            value="1">
                                            Active
                                        </option>
                                        <option <?php echo e(old('status', $category->status) == '0' ? 'selected' : ''); ?>

                                            value="0">
                                            Disable
                                        </option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control summernote" rows="8" cols="80"><?php echo e(old('description', $category->description)); ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
            <!-- .card -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('.dropify').dropify();

        var subcategory_id = $('select[name=subcategory_id]').val();
        var childsubcategory_id = $('select[name=childsubcategory_id]').val();
        if (subcategory_id) {
            $(".student-group").fadeIn();
        }
        if (childsubcategory_id) {
            $(".student-group1").fadeIn();
        }

        function getCategory(val) {
            var _token = $('input[name=_token]').val();
            $.ajax({
                type: "POST",
                url: "<?php echo e(url('dashboard/groups/categories')); ?>",
                data: {
                    _token: _token,
                    group_id: val
                },
                beforeSend: function() {
                    $("#preloader").css("display", "block");
                },
                success: function(data) {
                    $("#preloader").css("display", "none");
                    $(".student-group").fadeOut();
                    $(".student-group1").fadeOut();
                    $('select[name=parent_category]').html(data);
                    $('select[name=subcategory_id]').val(null);
                    $('select[name=childsubcategory_id]').val(null);
                }
            });
        }

        function getData(val) {
            var _token = $('input[name=_token]').val();
            var category_id = $('select[name=parent_category]').val();
            $.ajax({
                type: "POST",
                url: "<?php echo e(url('dashboard/categories/getCategory')); ?>",
                data: {
                    _token: _token,
                    category_id: category_id
                },
                beforeSend: function() {
                    $("#preloader").css("display", "block");
                },
                success: function(data) {
                    $("#preloader").css("display", "none");
                    $(".student-group").fadeIn();
                    $(".student-group1").fadeOut();
                    $('select[name=subcategory_id]').html(data);
                    $('select[name=childsubcategory_id]').val(null);
                }
            });

        }

        function getSubCategory(val) {
            var _token = $('input[name=_token]').val();
            var subcategory_id = $('select[name=subcategory_id]').val();
            $.ajax({
                type: "POST",
                url: "<?php echo e(url('dashboard/categories/getCategory')); ?>",
                data: {
                    _token: _token,
                    category_id: subcategory_id
                },
                beforeSend: function() {
                    $("#preloader").css("display", "block");
                },
                success: function(data) {
                    $("#preloader").css("display", "none");
                    $(".student-group1").fadeIn();
                    $('select[name=childsubcategory_id]').html(data);
                }
            });

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/backend/categories/category-edit.blade.php ENDPATH**/ ?>