<?php if($paginator->hasPages()): ?>
    <ul class="styled-pagination centered">
        
        <?php if($paginator->onFirstPage()): ?>
            <li class="disabled" aria-disabled="true" aria-label="<?php echo app('translator')->get('pagination.previous'); ?>">
                <a href="#">
                    <span class="fa fa-angle-double-left"></span>

                </a>
            </li>
        <?php else: ?>
            <li class="arrow prev">
                <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" aria-label="<?php echo app('translator')->get('pagination.previous'); ?>">
                    <span class="fa fa-angle-double-left"></span>
                </a>
            </li>
        <?php endif; ?>

        
        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <?php if(is_string($element)): ?>
                <li class="disabled" aria-disabled="true">
                    <span><?php echo e($element); ?></span>
                </li>
            <?php endif; ?>

            
            <?php if(is_array($element)): ?>
                <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $paginator->currentPage()): ?>
                        <li aria-current="page"><a class="active"><?php echo e($page); ?></a></li>
                    <?php else: ?>
                        <li>
                            <a href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if($paginator->hasMorePages()): ?>
            <li>
                <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" aria-label="<?php echo app('translator')->get('pagination.next'); ?>">
                    <span class="fa fa-angle-double-right"></span>
                </a>
            </li>
        <?php else: ?>
            <li class="disabled" aria-disabled="true" aria-label="<?php echo app('translator')->get('pagination.next'); ?>">
                <a href="#">

                    <span class="fa fa-angle-double-right"></span>
                </a>
            </li>
        <?php endif; ?>
    </ul>
<?php endif; ?>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/vendor/pagination/bootstrap-4.blade.php ENDPATH**/ ?>