<?php $__env->startSection('title', get_seo_page('contact-us')->seo_title ?? 'Contact Us'); ?>

<?php $__env->startSection('headerTitle', 'Contact Us'); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Contact Us</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('contact-us')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description"
        content="<?php echo e(get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="<?php echo e(get_seo_page('contact-us')->seo_title ?? 'Contact Us - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title"
        content="<?php echo e(get_seo_page('contact-us')->seo_title ?? 'Contact Us - ' . get_option('title')); ?>">
    <meta name="og:description"
        content="<?php echo e(get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('contact-us')->seo_title ?? 'Contact Us' . get_option('title')); ?></h1>
    <!--Contact Info Start-->
    <section class="contact-info">
        <div class="container">
            <div class="row g-4">
                <!--Contact Two Single Start-->
                <div class="col-xl-4 col-lg-4 wow fadeInLeft" data-wow-delay="100ms">
                    <div class="contact-info__single h-100">
                        <div class="contact-info__icon">
                            <span class="icon-call"></span>
                        </div>
                        <p>Contact Us</p>
                        <h3>
                            <a href="tel:<?php echo e(get_option('mobile_phone_first')); ?>">
                                <?php echo e(get_option('mobile_phone_first')); ?>

                            </a>
                        </h3>
                    </div>
                </div>
                <!--Contact Two Single End-->
                <!--Contact Two Single Start-->
                <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                    <div class="contact-info__single h-100">
                        <div class="contact-info__icon">
                            <span class="icon-email"></span>
                        </div>
                        <p>Email Us</p>
                        <h3><a href="mailto:<?php echo e(get_option('email')); ?>"><?php echo e(get_option('email')); ?></a></h3>
                    </div>
                </div>
                <!--Contact Two Single End-->
                <!--Contact Two Single Start-->
                <div class="col-xl-4 col-lg-4 wow fadeInRight" data-wow-delay="300ms">
                    <div class="contact-info__single h-100">
                        <div class="contact-info__icon">
                            <span class="icon-maps-and-flags"></span>
                        </div>
                        <p>Office Location</p>
                        <h3><?php echo e(get_option('address')); ?></h3>
                    </div>
                </div>
                <!--Contact Two Single End-->

                <!--Contact Two Single Start-->
                <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                    <div class="contact-info__single h-100">
                        <div class="contact-info__icon">
                            <span class="icon-maps-and-flags"></span>
                        </div>
                        <p>Work Location</p>
                        <h3>H-114 TO H-117, V.K.I. Extenstion Area, Road No. 14, Badarana, Jaipur-302013</h3>
                    </div>
                </div>
                <!--Contact Two Single End-->
                <!--Contact Two Single Start-->
                <div class="col-xl-4 col-lg-4 wow fadeInRight" data-wow-delay="300ms">
                    <div class="contact-info__single h-100">
                        <div class="contact-info__icon">
                            <span class="icon-maps-and-flags"></span>
                        </div>
                        <p>Work Location</p>
                        <h3>
                            G-43 -45, V.K.I.Extension area, road no. 14, Badharna, Jaipur -302013
                        </h3>
                    </div>
                </div>
                <!--Contact Two Single End-->
                <!--Contact Two Single Start-->
                <div class="col-xl-4 col-lg-4 wow fadeInLeft" data-wow-delay="100ms">
                    <div class="contact-info__single h-100">
                        <div class="contact-info__icon">
                            <span class="icon-maps-and-flags"></span>
                        </div>
                        <p>Unit II</p>
                        <h3>
                            A-25 (A) & A25 (B) A, Shri Khatu Shyam Industrial area, Reengus, Sikar, Rajasthan-332404
                        </h3>
                    </div>
                </div>
                <!--Contact Two Single End-->
            </div>
        </div>
    </section>
    <!--Contact Info End-->


    <!--Contact Page Start-->
    <section class="contact-page">
        <div class="container">
            <div class="contact-page__inner">
                <div class="row">
                    <div class="col-xl-6">
                        <div class="contact-page__left">
                            <iframe src="<?php echo e(get_option('google_map')); ?>" class="google-map__one" allowfullscreen></iframe>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="contact-page__right">
                            <h3 class="contact-page__form-title">Get A Free Quote</h3>
                            <form id="contact-form" class=" contact-page__form" action="<?php echo e(route('contact.store')); ?>"
                                method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="contact-page__input-box">
                                            <input type="text" name="name" placeholder="Your name"
                                                value="<?php echo e(old('name')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="contact-page__input-box">
                                            <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                                                placeholder="Your Email" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="contact-page__input-box">
                                            <input type="text" placeholder="Mobile" name="phone_number"
                                                value="<?php echo e(old('phone_number')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="contact-page__input-box">
                                            <input type="text" placeholder="Subject" name="subject"
                                                value="<?php echo e(old('subject')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-12">
                                        <div class="contact-page__input-box text-message-box">
                                            <textarea name="message" placeholder="Message" required=""><?php echo e(old('message')); ?></textarea>
                                        </div>
                                        <div class="contact-page__btn-box">
                                            <button type="submit" style="color: var(--suntop-base)"
                                                class="thm-btn bg-white contact-page__btn"
                                                data-loading-text="Please wait...">Send A Message
                                                <i class="icon-right-arrow"></i>
                                                <span class="hover-btn hover-bx"></span>
                                                <span class="hover-btn hover-bx2"></span>
                                                <span class="hover-btn hover-bx3"></span>
                                                <span class="hover-btn hover-bx4"></span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="result"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Contact Page End-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/contacts/contact-index.blade.php ENDPATH**/ ?>