<?php $__env->startSection('title', $product->seo_title ?? $product->title); ?>

<?php $__env->startSection('headerTitle', $product->title); ?>


<?php $__env->startSection('header'); ?>
    <li> <a href="<?php echo e(route('product.index')); ?>">Products</a> </li>

    <li class="breadcrumb-item active"><?php echo e($product->title); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($product->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e($product->seo_description ?? $product->summary); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($product->seo_title ?? $product->title); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/products/' . $product->image)); ?>">
    <meta name="twitter:description" content="<?php echo e($product->seo_description ?? $product->summary); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($product->seo_title ?? $product->title); ?>">
    <meta name="og:description" content="<?php echo e($product->seo_description ?? $product->summary); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/products/' . $product->image)); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="/frontend/css/custom.css">
    <style>
        .highlight-one__single-img {
            height: 320px;
        }

        .highlight-one__single-content h2 a {
            font-size: 20px
        }

        .page-header {
            padding: 30px 0px 40px
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($product->seo_title ?? $product->title); ?></h1>
    <section class="shop-detail">
        <div class="auto-container">

            <div class="row clearfix">
                <!-- Gallery Column -->
                <div class="shop-detail_gallery-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <div class="carousel-outer">
                            <!-- Swiper -->
                            <div class="swiper-container content-carousel">
                                <div class="swiper-wrapper">

                                    <div class="swiper-slide">
                                        <figure class="image">
                                            <a href="<?php echo e($product->imageUrl); ?>" class="lightbox-image">
                                                <img src="<?php echo e($product->imageUrl); ?>" alt="<?php echo e($product->title); ?>">
                                            </a>
                                        </figure>
                                    </div>
                                    <?php if($product?->images): ?>
                                        <?php if(count(json_decode($product?->images))): ?>
                                            <?php $__currentLoopData = json_decode($product?->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <figure class="image">
                                                        <a href="/frontend/images/products/<?php echo e($item); ?>"
                                                            class="lightbox-image">
                                                            <img src="/frontend/images/products/<?php echo e($item); ?>"
                                                                alt="<?php echo e($product->title); ?>">
                                                        </a>
                                                    </figure>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="swiper-container thumbs-carousel">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <figure class="thumb">
                                            <img class="h-100 w-100" src="<?php echo e($product->imageUrl); ?>"
                                                alt="<?php echo e($product->title); ?>">
                                        </figure>
                                    </div>
                                    <?php if($product?->images): ?>
                                        <?php if(count(json_decode($product?->images))): ?>
                                            <?php $__currentLoopData = json_decode($product?->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <figure class="thumb">
                                                        <img class="h-100 w-100"
                                                            src="/frontend/images/products/<?php echo e($item); ?>"
                                                            alt="<?php echo e($product->title); ?>">
                                                    </figure>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Content Column -->
                <div class="shop-detail_content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <h3 class="shop-detail_title"><?php echo e($product->title); ?></h3>
                        <!-- Rating -->

                        <div class="shop-detail_text">
                            <?php echo e($product->summary); ?>

                        </div>

                        <ul class="shop-detail_list alternate">
                            <li>
                                <i class="flaticon-check-mark"></i>
                                <strong>Category:</strong> <?php echo e($product?->category?->title); ?>

                            </li>
                        </ul>
                        <div class="d-flex align-items-center flex-wrap">

                            <!-- Button Box -->
                            <div class="button-box ms-0">
                                <button type="button" data-bs-toggle="modal" data-bs-target="#enquiry"
                                    class="theme-btn btn-style-one">
                                    <span class="btn-wrap">
                                        <span class="text-one">Enquiry Now</span>
                                        <span class="text-two">Enquiry Now</span>
                                    </span>
                                </button>
                            </div>
                        </div>
                        <!-- Socials -->
                        <div class="shop-detail_socials">
                            <span>Share:</span>
                            <a class="fa-brands fa-facebook-f fa-fw"
                                href="https://facebook.com/sharer/sharer.php?u=<?php echo e(request()->url()); ?>"></a>
                            <a class="fa-brands fa-twitter fa-fw"
                                href="https://twitter.com/intent/tweet?text=<?php echo e($product->title); ?>&url=<?php echo e(request()->url()); ?>"></a>
                            <a class="fa-brands fa-linkedin fa-fw"
                                href="https://www.linkedin.com/shareArticle?url=<?php echo e(request()->url()); ?>&title=<?php echo e($product->title); ?>"></a>
                            <a class="fa-brands fa-pinterest fa-fw"
                                href="https://www.pinterest.com/pin/create/button?url=<?php echo e($product->title); ?>&media=<?php echo e($product->imageUrl); ?>&description=<?php echo e($product->title); ?>"></a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lower Box -->
            <div class="lower-box">

                <!-- Product Info Tabs -->
                <div class="product-info-tabs">
                    <!-- Product Tabs -->
                    <div class="prod-tabs tabs-box">

                        <!-- Tab Btns -->
                        <ul class="tab-btns tab-buttons clearfix">
                            <li data-tab="#prod-info" class="tab-btn active-btn">Description</li>
                            <li data-tab="#prod-specifications" class="tab-btn">Specifications</li>
                        </ul>

                        <!-- Tabs Container -->
                        <div class="tabs-content">

                            <!-- Tab -->
                            <div class="tab active-tab" id="prod-info">
                                <div class="content">
                                    <?php echo $product->description; ?>

                                </div>
                            </div>

                            <!-- Tab -->
                            <div class="tab" id="prod-specifications">
                                <div class="content">
                                    <?php echo $product->specification; ?>

                                </div>
                            </div>

                            <!--Tab-->


                        </div>
                    </div>

                </div>
                <!--End Product Info Tabs-->

            </div>
            <!-- End Lower Box -->

            <?php if(get_products_by_category($product?->category?->title)): ?>
                <!-- Related Products -->
                <div class="related-products">
                    <h3>Related Products</h3>
                    <div class="row clearfix">

                        <?php $__currentLoopData = get_products_by_category($product?->category?->title)->except($product->id)->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Shop Block One -->
                            <div class="shop-block_one col-lg-4 col-md-6 col-sm-6">
                                <div class="shop-block_one-inner">
                                    <div class="shop-block_one-image">
                                        <a href="<?php echo e(route('product.show', $item)); ?>">
                                            <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>" />
                                        </a>
                                    </div>
                                    <div class="shop-block_one-content">
                                        <h4 class="shop-block_one-heading">
                                            <a href="<?php echo e(route('product.show', $item)); ?>">
                                                <?php echo e($item->title); ?>

                                            </a>
                                        </h4>

                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                </div>
            <?php endif; ?>

        </div>
    </section>




    <style>
        .custom-close-btn {
            border: 1px solid white;
            padding: 10px;
            height: 38px;
            width: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50rem;
            color: white;
            background: linear-gradient(135deg, #7b2f8e 0%, #8e2c7c 50%, #b11f5a 100%);
        }

        .contact-page__form-title {
            font-size: 32px
        }
    </style>

    <!-- Enquiry-from -->
    <div class="modal fade" id="enquiry">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content contact-page__inner p-0">

                <div class="modal-body p-5">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h3 class="contact-page__form-title mb-0">Get A Quote</h3>

                        <button type="button" class="custom-close-btn" data-bs-dismiss="modal" aria-label="Close">
                            <i class="fas fa-times"></i>
                        </button>

                    </div>

                    <div class="contact-form">

                        <form id="contact-form" class=" contact-page__form"
                            action="<?php echo e(route('product.store', $product)); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" name="first_name" value="<?php echo e(old('first_name')); ?>"
                                            placeholder="Your First name" required="" />
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" name="last_name" value="<?php echo e(old('last_name')); ?>"
                                            placeholder="Your Last name" required="" />
                                    </div>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                                            placeholder="Your Email" required="" />
                                    </div>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" name="phone_number" value="<?php echo e(old('phone_number')); ?>"
                                            placeholder="Phone Number" required="" />
                                    </div>
                                </div>

                                <div class="col-xl-12 col-lg-12 form-group">
                                    <div class="contact-page__input-box">
                                        <input type="text" placeholder="Your Address" value="<?php echo e(old('address')); ?>"
                                            name="address" />
                                    </div>
                                </div>

                                <div class="col-xl-12 form-group">
                                    <div class="contact-page__input-box text-message-box">
                                        <textarea name="remarks" placeholder="If any query"><?php echo e(old('remarks')); ?></textarea>
                                    </div>
                                </div>

                                <div class="cta-one__btn become__a_dealer">
                                    <button type="submit" class="theme-btn btn-style-one">
                                        <span class="btn-wrap">
                                            <span class="text-one">Send Message</span>
                                            <span class="text-two">Send Message</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Enquiry-form -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/products/product-show.blade.php ENDPATH**/ ?>