<?php $__env->startSection('header'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('product_requests.index')); ?>">Product List</a></li>
<li class="breadcrumb-item active">Show Product</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span>
                    Product Details
                </span>
            </div>
            <div class="card-body row">
                <div class="col-md-6">
                    <div class="card panel box box-primary">
                        <div class="card-header">
                            Client Detail
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item">
                                    <strong>User Type</strong>: <?php echo e($productRequest->type); ?>

                                </li>
                                <li class="list-group-item">
                                    <strong>Full Name</strong>: <?php echo e($productRequest->name); ?>

                                </li>
                                <?php if($productRequest->company_name): ?>
                                <li class="list-group-item">
                                    <strong>Company Name</strong>: <?php echo e($productRequest->company_name); ?>

                                </li>
                                <?php endif; ?>
                                <li class="list-group-item">
                                    <strong>Phone Number</strong>: <?php echo e($productRequest->phone_number); ?>

                                </li>
                                <li class="list-group-item">
                                    <strong>Email</strong>: <?php echo e($productRequest->email); ?>

                                </li>
                                <li class="list-group-item">
                                    <strong>Address</strong>: <?php echo e($productRequest->address); ?>

                                </li>
                                <?php if($productRequest->remarks): ?>
                                <li class="list-group-item">
                                    <strong>Description</strong>: <?php echo e($productRequest->remarks); ?>

                                </li>
                                <?php endif; ?>
                                <li class="list-group-item">
                                    <strong>Created</strong> : <?php echo e($productRequest->created_at->format('d M, Y')); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Product Name</strong> : <?php echo e($productRequest->product->title); ?>

                    </li>
                    <li class="list-group-item">
                        <strong>Category</strong> : <?php echo e($productRequest->product->category->title); ?>

                    </li>
                    <?php if($productRequest->product->weight): ?>
                    <li class="list-group-item">
                        <strong>Weight</strong> : <?php echo e($productRequest->product->weight . ' ' . $productRequest->product->unit); ?>

                    </li>
                    <?php endif; ?>
                    <?php if($productRequest->product->mrp_price): ?>
                    <li class="list-group-item">
                        <strong> Mrp Price</strong> : Rs. <?php echo e($productRequest->product->mrp_price); ?>

                    </li>
                    <li class="list-group-item">
                        <strong> Offfered Price</strong> : <?php echo e($productRequest->product->offer_price); ?>

                    </li>
                    <?php endif; ?>

                    <?php if($productRequest->product->in_stock): ?>
                    <li class="list-group-item">
                        <strong>In stock</strong> : <?php echo e($productRequest->product->in_stock); ?>

                    </li>
                    <?php endif; ?>

                    <li class="list-group-item">
                        <strong>Created</strong> : <?php echo e($productRequest->product->created_at->diffForHumans()); ?>

                    </li>
                    <li class="list-group-item">
                        <strong>Created by</strong> : <?php echo e($productRequest->product->user->name); ?>

                    </li>

                    <li class="list-group-item">
                        <strong>Description</strong> : <?php echo $productRequest->product->description; ?>


                    </li>
                </ul>
            </div>
        </div>
    </div>


</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/requests/request-show.blade.php ENDPATH**/ ?>