<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('products.index')); ?>">Product List</a></li>
    <li class="breadcrumb-item active">Show Product</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span>
                        Product Details
                    </span>
                    <div>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product-create')): ?>
                            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-secondary btn-sm">Add Product</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product-edit')): ?>
                            <a href="<?php echo e(route('products.edit', $product->slug)); ?>" class="btn btn-primary "> Edit This
                                Product</a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body row">
                    <div class="col-md-6">
                        <div class="card panel box box-primary">
                            <div class="card-header">
                                Image
                            </div>
                            <div class="card-body">
                                <?php if($product->image): ?>
                                    <img class="img-responsive product_image"
                                        src="/frontend/images/products/<?php echo e($product->image); ?>" width="100%" height="auto">
                                <?php else: ?>
                                    <img class="img-responsive product_image" src="/frontend/images/profile.png"
                                        width="100%" height="auto">
                                <?php endif; ?>

                            </div>
                        </div>
                        <ul class="list-group col-md-12 mt-4">
                            <li class="list-group-item">
                                <strong>Seo Title</strong> : <?php echo e($product->seo_title); ?>

                            </li>
                            <li class="list-group-item">
                                <strong>Seo Keyword</strong> : <?php echo e($product->seo_keyword); ?>

                            </li>
                            <li class="list-group-item">
                                <strong>Seo Description</strong> : <?php echo e($product->seo_description); ?>

                            </li>
                        </ul>
                    </div>

                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Title</strong> : <?php echo e($product->title); ?>

                        </li>
                        <li class="list-group-item">
                            <strong>Category</strong> : <?php echo e($product->category ? $product->category->title : ''); ?>

                        </li>
                        <li class="list-group-item">
                            <strong>Created</strong> :
                            <?php echo e($product->created_at ? $product->created_at->diffForHumans() : '-'); ?>

                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : <?php echo e($product->user ? $product->user->name : '-'); ?>

                        </li>
                        <li class="list-group-item">
                            <?php echo $product->summary; ?>

                        </li>
                        <li class="list-group-item">
                            <?php echo $product->description; ?>

                        </li>
                        <li class="list-group-item">
                            <?php echo $product->specification; ?>

                        </li>
                    </ul>

                    <div class="col-md-12">
                        <?php if(count(json_decode($product->images))): ?>
                            <div class="row g-4 mt-5 border-top">
                                <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-3">
                                        <img class="w-100" src="/frontend/images/products/<?php echo e($item); ?>"
                                            alt="">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/backend/products/show.blade.php ENDPATH**/ ?>