<?php $__env->startSection('title', get_seo_page('contact-us')->seo_title ?? 'Contact Us'); ?>

<?php $__env->startSection('headerTitle', 'Contact Us'); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Contact Us</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('contact-us')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description"
        content="<?php echo e(get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="<?php echo e(get_seo_page('contact-us')->seo_title ?? 'Contact Us - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title"
        content="<?php echo e(get_seo_page('contact-us')->seo_title ?? 'Contact Us - ' . get_option('title')); ?>">
    <meta name="og:description"
        content="<?php echo e(get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('contact-us')->seo_title ?? 'Contact Us' . get_option('title')); ?></h1>
    <!--Contact Info Start-->

    <!-- Map One -->
    <section class="map-one">
        <div class="container">
            <div class="row clearfix">

                <!-- Info Column -->
                <div class="info-column col-lg-5 col-md-12 col-sm-12">
                    <div class="info-column_inner">
                        <h3 class="map-one_title">Please Don't Hesitate To Contact Us </h3>
                        <div class="map-one_text">You can also reach out to us by phone or email</div>
                        <ul class="map-one_info">
                            <li>
                                <span class="icon flaticon-map"></span>
                                <strong>Address</strong>
                                <?php echo e(get_option('address')); ?>

                            </li>
                            <li>
                                <span class="icon flaticon-telephone-1"></span>
                                <strong>Contact</strong>
                                <a href="tel:<?php echo e(get_option('mobile_phone_first')); ?>">
                                    <?php echo e(get_option('mobile_phone_first')); ?>

                                </a>
                                <br>
                                <a href="mailto:<?php echo e(get_option('email')); ?>">
                                    <span><?php echo e(get_option('email')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Team Block One -->
                <div class="map-column col-lg-7 col-md-12 col-sm-12">
                    <div class="map-column_inner">
                        <iframe src="<?php echo e(get_option('google_map')); ?>" allowfullscreen=""></iframe>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Map One -->

    <!-- Contact Two -->
    <section class="contact-two" style="background-image:url(/frontend/images/background/26.jpg)">
        <div class="container">
            <div class="row align-items-center clearfix">

                <!-- Form Column -->
                <div class="contact-two_form-column col-lg-6 col-md-12 col-sm-12">
                    <div class="contact-two-form_outer">
                        <!-- Contact Form -->
                        <div class="contact-form">
                            <form method="post" action="<?php echo e(route('contact.store')); ?>" id="contact-form">
                                <?php echo csrf_field(); ?>
                                <div class="row clearfix">

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>First Name</label>
                                        <input type="text" name="first_name" value="<?php echo e(old('first_name')); ?>"
                                            placeholder="First Name" required="">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>Last Name</label>
                                        <input type="text" name="last_name" value="<?php echo e(old('last_name')); ?>"
                                            placeholder="Last Name" required="">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>Phone No.</label>
                                        <input type="text" name="phone_number" value="<?php echo e(old('phone_number')); ?>"
                                            placeholder="Your Phone" required="">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>Email</label>
                                        <input type="text" name="email" value="<?php echo e(old('email')); ?>"
                                            placeholder="Your Email" required="">
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <label>Subject</label>
                                        <input type="text" name="subject" value="<?php echo e(old('subject')); ?>"
                                            placeholder="Subject" required="">
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <label>Message</label>
                                        <textarea class="" name="message" placeholder="Your Request"><?php echo e(old('message')); ?></textarea>
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <!-- Button Box -->
                                        <button type="submit" class="theme-btn btn-style-one">
                                            <span class="btn-wrap">
                                                <span class="text-one">Send Message</span>
                                                <span class="text-two">Send Message</span>
                                            </span>
                                        </button>
                                    </div>

                                </div>
                            </form>
                        </div>
                        <!-- End Contact Form -->
                    </div>
                </div>

                <!-- Team Block One -->
                <div class="contact-two_title-column col-lg-6 col-md-12 col-sm-12">
                    <div class="contact-two_title-outer">
                        <h3 class="contact-two_title">To Speak To Our Friendly Team, Please Contact</h3>
                        <div class="contact-two_text">Drop us a line and we will ensure the appropriate team responds to
                            your enquiry.</div>
                        <div class="contact-two_support">
                            <img src="/frontend/images/abouts/about-image-1.png" alt="" />
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Contact Two -->




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/contacts/contact-index.blade.php ENDPATH**/ ?>