<?php $__env->startSection('header'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('categories.index')); ?>">Category List</a></li>
<li class="breadcrumb-item active">View Category</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Category Details
                </span>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-create')): ?>
                <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-secondary btn-sm">Add Category</a>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="list-group col-md-6">
                        <div class="card panel box box-primary">
                            <div class="card-header">
                                <h6 class="card-title">Child categories</h6>
                            </div>
                            <div class="card-body">
                                <h4><?php echo e($category->name); ?></h4>
                                <?php if(count($category->childs)): ?>
                                    <?php $__currentLoopData = $category->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <span><?php echo e($child->title); ?></span>
                                            </li>
                                            <?php if(count($child->childs)): ?>
                                                <?php echo $__env->make('backend.categories.child', ['childs'=> $child->childs], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endif; ?>
                                        </ul>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Name</strong> : <?php echo e($category->title); ?>

                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : <?php echo e($category->user->name); ?>

                        </li>
                        <?php if($category->image): ?>
                        <li class="list-group-item">
                            <img src="/frontend/images/categories/<?php echo e($category->image); ?>" height="150px" width="150px">
                        </li>
                        <?php endif; ?>
                    </ul>
                    <div class="col-lg-12">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
                        <a href="<?php echo e(route('categories.edit', $category)); ?>" class="btn btn-primary"> Edit This Category</a>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>


</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/backend/categories/category-show.blade.php ENDPATH**/ ?>