<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('events.index')); ?>">Event List</a></li>
    <li class="breadcrumb-item active">Add Event</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.0/min/dropzone.min.css">
    <style media="screen">
        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 34px !important;
            background: #f2f2f2;
            border-radius: 5px;
        }

        .select2-container {
            display: block;
        }
    </style>
    <style>
        .dropzone {
            border: 2px dashed #aaa;
            border-radius: 10px;
            padding: 30px;
            text-align: center;
            position: relative;
            cursor: pointer;
            background-color: #f9f9f9;
            transition: border 0.3s;
        }

        .dropzone.dragover {
            border-color: #3f51b5;
            background-color: #f1f1f1;
        }

        .dropzone input[type="file"] {
            position: absolute;
            inset: 0;
            opacity: 0;
            cursor: pointer;
        }

        .image-preview-area {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }

        .image-preview-box {
            position: relative;
            width: 120px;
            height: 120px;
            overflow: hidden;
            border: 1px solid #ccc;
            border-radius: 8px;
        }

        .image-preview-box img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .remove-btn {
            position: absolute;
            top: 5px;
            right: 5px;
            background-color: rgba(255, 0, 0, 0.8);
            color: white;
            border: none;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            line-height: 20px;
            text-align: center;
            font-size: 14px;
            cursor: pointer;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 34px !important;
            background: #f2f2f2;
            border-radius: 5px;
        }

        .select2-container {
            display: block;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <form class="form-group" method="post" action="<?php echo e(route('events.store')); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <span class="card-title">Add Event</span>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label class="form-label">Event Name <span class="text-danger">*</span>
                                            </label>
                                            <input class="form-control" type="text" id="title" name="title"
                                                value="<?php echo e(old('title')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Event Slug <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" id="slug" name="slug"
                                                value="<?php echo e(old('slug')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Location <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="location"
                                                value="<?php echo e(old('location')); ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Status <span class="text-danger">*</span> </label>
                                            <select name="status" class="form-control select2">
                                                <option value="">Select One</option>
                                                <option <?php echo e(old('status') == '1' ? 'selected' : ''); ?> value="1">Active
                                                </option>
                                                <option <?php echo e(old('status') == '0' ? 'selected' : ''); ?> value="0">Disable
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



            <div class="col-md-12">
                <div class="accordion" id="detailManage">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Manage Detail
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#detailManage">
                            <div class="accordion-body">
                                <div class="row g-4">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">Description <span class="text-danger">*</span>
                                            </label>
                                            <textarea rows="8" class="form-control summernote" type="text" name="description" required><?php echo e(old('description')); ?></textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="accordion" id="imageManage">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Manage Image
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#imageManage">
                        <div class="accordion-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label">Featured Image <span class="text-danger">*</span></label>

                                    <input type="file" class="form-control dropify" name="image" required>
                                </div>
                                <div class="col-md-8">
                                    <label class="form-label">Upload Images <span class="text-danger">*</span></label>

                                    <div id="customDropArea" class="dropzone">
                                        <p>Drag & drop images here or click to browse</p>
                                        <input type="file" name="images[]" id="imageInput" accept="image/*" multiple>
                                    </div>

                                    <div id="imagePreview" class="image-preview-area mt-3"></div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seo-manage')): ?>
                <div class="col-md-12">
                    <div class="accordion" id="seoManage">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    Manage SEO
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#seoManage">
                                <div class="accordion-body">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label">SEO Title </label>
                                            <input type="text" class="form-control" name="seo_title"
                                                value="<?php echo e(old('seo_title')); ?>">
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">SEO Keyword </label>
                                            <input type="text" class="form-control tagEditor" name="seo_keyword"
                                                value="<?php echo e(old('seo_keyword')); ?>">
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label">SEO Description </label>
                                            <textarea class="form-control" name="seo_description" rows="8" cols="80"><?php echo e(old('seo_description')); ?></textarea>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-4">

                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('backend.products.form.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
        $(document).on('click', '#add_slide', function() {
            $form = $(".repeat").clone().removeClass("repeat");
            $form.removeClass("d-none");
            $form.find("input,textarea").val("");
            $form.find("textarea").summernote({
                height: 200,
            });
            $("#slider_submit").before($form);
        });

        $(document).on('click', '.remove-row', function() {
            $(this).parent().remove();
        });

        $('.summernote').summernote({
            height: 230,
        });

        const imageInput = document.getElementById('imageInput');
        const dropArea = document.getElementById('customDropArea');
        const previewContainer = document.getElementById('imagePreview');
        const form = document.getElementById('houseTypeForm');

        let selectedImages = [];

        dropArea.addEventListener('click', () => imageInput.click());

        dropArea.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropArea.classList.add('dragover');
        });

        dropArea.addEventListener('dragleave', () => {
            dropArea.classList.remove('dragover');
        });

        dropArea.addEventListener('drop', (e) => {
            e.preventDefault();
            dropArea.classList.remove('dragover');
            const files = Array.from(e.dataTransfer.files).filter(f => f.type.startsWith('image/'));
            selectedImages.push(...files);
            updatePreview();
        });

        imageInput.addEventListener('change', () => {
            const files = Array.from(imageInput.files).filter(f => f.type.startsWith('image/'));
            selectedImages.push(...files);
            updatePreview();
        });

        function updatePreview() {
            previewContainer.innerHTML = '';

            selectedImages.forEach((file, index) => {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const wrapper = document.createElement('div');
                    wrapper.className = 'image-preview-box';

                    const img = document.createElement('img');
                    img.src = e.target.result;

                    const btn = document.createElement('button');
                    btn.className = 'remove-btn';
                    btn.innerHTML = '&times;';
                    btn.onclick = () => {
                        selectedImages.splice(index, 1);
                        updatePreview();
                    };

                    wrapper.appendChild(img);
                    wrapper.appendChild(btn);
                    previewContainer.appendChild(wrapper);
                };
                reader.readAsDataURL(file);
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/events/event-create.blade.php ENDPATH**/ ?>