<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="/frontend/images/favicon.jpeg" />
    <link rel="icon" type="image/jpeg" sizes="32x32" href="/frontend/images/favicon.jpeg" />
    <link rel="icon" type="image/jpeg" sizes="16x16" href="/frontend/images/favicon.jpeg" />
    <link rel="manifest" href="/frontend/images/favicon.jpeg" />
    <link rel="shortcut icon" type="image/x-icon" href="/frontend/images/favicon.jpeg">

    <?php if(Nav::isRoute('page.index')): ?>
        <title><?php echo e(get_option('seo_title') ? get_option('seo_title') : get_option('title')); ?></title>
    <?php else: ?>
        <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(get_option('title')); ?></title>
    <?php endif; ?>

    <meta property="og:site_name" content="<?php echo e(get_option('title')); ?>">


    <?php echo $__env->yieldContent('meta'); ?>
    <?php if(Nav::isRoute('product.index')): ?>
        <link rel="stylesheet" href="/css/app.css">
    <?php endif; ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&amp;display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="/frontend/css/bootstrap.min.css" />
    <link rel="stylesheet" href="/frontend/css/animate.min.css" />
    <link rel="stylesheet" href="/frontend/css/custom-animate.css" />
    <link rel="stylesheet" href="/frontend/css/swiper.min.css" />
    <link rel="stylesheet" href="/frontend/css/font-awesome-all.css" />
    <link rel="stylesheet" href="/frontend/css/jarallax.css" />
    <link rel="stylesheet" href="/frontend/css/jquery.magnific-popup.css" />
    <link rel="stylesheet" href="/frontend/css/odometer.min.css" />
    <link rel="stylesheet" href="/frontend/css/flaticon.css">
    <link rel="stylesheet" href="/frontend/css/owl.carousel.min.css" />
    <link rel="stylesheet" href="/frontend/css/owl.theme.default.min.css" />
    <link rel="stylesheet" href="/frontend/css/nice-select.css" />
    <link rel="stylesheet" href="/frontend/css/jquery-ui.css" />
    <link rel="stylesheet" href="/frontend/css/twentytwenty.css" />
    <link rel="stylesheet" href="/frontend/css/aos.css" />

    <link rel="stylesheet" href="/frontend/css/module-css/slider.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/footer.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/page-header.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/service.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/about.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/team.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/process.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/contact.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/pricing.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/blog.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/counter.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/faq.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/shop.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/highlight.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/cta.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/features.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/sliding-text.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/brand.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/testimonial.css" />
    <link rel="stylesheet" href="/frontend/css/module-css/error.css" />

    <!-- template styles -->
    <link rel="stylesheet" href="/frontend/css/style.css" />
    <link rel="stylesheet" href="/frontend/css/responsive.css" />
    <link rel="stylesheet" href="/backend1/css/toastr.css">
    <?php echo $__env->yieldContent('styles'); ?>

    <?php $__currentLoopData = get_plugins('Header'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $plugin->code; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</head>

<body class="custom-cursor">
    <?php $__currentLoopData = get_plugins('Body'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $plugin->code; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="custom-cursor__cursor"></div>
    <div class="custom-cursor__cursor-two"></div>

    <!--Start Preloader-->
    <div class="loader js-preloader">
        <div></div>
        <div></div>
        <div></div>
    </div>
    <!--End Preloader-->



    <div class="chat-icon"><button type="button" class="chat-toggler"><i class="fa fa-comment"></i></button></div>
    <!--Chat Popup-->
    <div id="chat-popup" class="chat-popup">
        <div class="popup-inner">
            <div class="close-chat"><i class="fa fa-times"></i></div>
            <div class="chat-form">
                <p>Please fill out the form below and we will get back to you as soon as possible.</p>
                <form action="<?php echo e(route('customer_enquiry.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <input type="text" name="name" value="<?php echo e(old('name')); ?>" placeholder="Your Name"
                            required>
                    </div>
                    <div class="form-group">
                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="Your Email"
                            required>
                    </div>
                    <div class="form-group">
                        <input type="text" name="phone_number" value="<?php echo e(old('phone_number')); ?>"
                            placeholder="Your Phone No." required>
                    </div>
                    <div class="form-group">
                        <textarea name="message" placeholder="Your Text" required><?php echo e(old('message')); ?></textarea>
                    </div>
                    <div class="form-group message-btn">
                        <button type="submit" class="thm-btn"> Submit Now
                            <span class="fas fa-arrow-right"></span>
                        </button>
                    </div>
                    <div class="result"></div>
                </form>
            </div>
        </div>
    </div>



    <div class="page-wrapper">

        <?php echo $__env->make('layouts.frontend.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(!Nav::isRoute('page.index')): ?>
            <section class="page-header">
                <div class="page-header__bg"
                    style="background-image: url(/frontend/images/backgrounds/page-header-bg.jpg)">
                </div>
                <div class="container">
                    <div class="page-header__inner">
                        <h2 class="wow fadeInDown" data-wow-duration="1500ms"><?php echo $__env->yieldContent('headerTitle'); ?></h2>
                        <ul class="thm-breadcrumb wow fadeInUp" data-wow-duration="1500ms">
                            <li><a href="<?php echo e(route('page.index')); ?>">Home</a></li>
                            <li><span class="icon-right-arrow"></span></li>
                            <?php echo $__env->yieldContent('header'); ?>
                        </ul>
                    </div>
                </div>
            </section>
        <?php endif; ?>

        <div class="stricky-header stricked-menu main-menu">
            <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
        </div><!-- /.stricky-header -->

        <?php echo $__env->yieldContent('content'); ?>

        <!--Start Site Footer -->
        <?php echo $__env->make('layouts.frontend.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--End Site Footer-->


    </div><!-- /.page-wrapper -->


    <div class="mobile-nav__wrapper">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <!-- /.mobile-nav__overlay -->
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

            <div class="logo-box">
                <a href="<?php echo e(route('page.index')); ?>" aria-label="logo image">
                    <img src="/frontend/images/logo.jpeg" width="150" alt="" /></a>
            </div>
            <!-- /.logo-box -->
            <div class="mobile-nav__container"></div>
            <!-- /.mobile-nav__container -->

            <ul class="mobile-nav__contact list-unstyled">
                <li>
                    <i class="fa fa-envelope"></i>
                    <a href="mailto:<?php echo e(get_option('email')); ?>"><?php echo e(get_option('email')); ?></a>
                </li>
                <li>
                    <i class="fas fa-phone"></i>
                    <a href="tel:<?php echo e(get_option('mobile_phone_first')); ?>"><?php echo e(get_option('mobile_phone_first')); ?></a>
                </li>
            </ul><!-- /.mobile-nav__contact -->
            <div class="mobile-nav__top">
                <div class="mobile-nav__social">
                    <a href="#" class="fab fa-twitter"></a>
                    <a href="#" class="fab fa-facebook-square"></a>
                    <a href="#" class="fab fa-pinterest-p"></a>
                    <a href="#" class="fab fa-instagram"></a>
                </div><!-- /.mobile-nav__social -->
            </div><!-- /.mobile-nav__top -->



        </div>
        <!-- /.mobile-nav__content -->
    </div>
    <!-- /.mobile-nav__wrapper -->




    <script src="/js/app.js" charset="utf-8"></script>
    <script src="/frontend/js/jquery-latest.js"></script>
    <script src="/frontend/js/bootstrap.bundle.min.js"></script>
    <script src="/frontend/js/jarallax.min.js"></script>
    <script src="/frontend/js/jquery.ajaxchimp.min.js"></script>
    <script src="/frontend/js/jquery.appear.min.js"></script>
    <script src="/frontend/js/swiper.min.js"></script>
    <script src="/frontend/js/jquery.circle-progress.min.js"></script>
    <script src="/frontend/js/knob.js"></script>
    <script src="/frontend/js/jquery.magnific-popup.min.js"></script>
    <script src="/frontend/js/jquery.validate.min.js"></script>
    <script src="/frontend/js/odometer.min.js"></script>
    <script src="/frontend/js/wNumb.min.js"></script>
    <script src="/frontend/js/wow.js"></script>
    <script src="/frontend/js/isotope.js"></script>
    <script src="/frontend/js/owl.carousel.min.js"></script>
    <script src="/frontend/js/jquery-ui.js"></script>
    <script src="/frontend/js/jquery.circleType.js"></script>
    <script src="/frontend/js/jquery.lettering.min.js"></script>
    <script src="/frontend/js/jquery.fittext.js"></script>
    <script src="/frontend/js/jquery.nice-select.min.js"></script>
    <script src="/frontend/js/marquee.min.js"></script>
    <script src="/frontend/js/countdown.min.js"></script>
    <script src="/frontend/js/jquery-sidebar-content.js"></script>
    <script src="/frontend/js/aos.js"></script>
    <script src="/frontend/js/gsap/gsap.js"></script>
    <script src="/frontend/js/gsap/ScrollTrigger.js"></script>
    <script src="/frontend/js/gsap/SplitText.js"></script>

    <script src="/frontend/js/script.js"></script>
    <script type="text/javascript" src="/backend1/js/toastr.js"></script>
    <?php echo $__env->make('layouts.backend.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldContent('scripts'); ?>
</body>


</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/layouts/frontend/main.blade.php ENDPATH**/ ?>