<?php $__env->startSection('title', $joblist->title . ' Details'); ?>

<?php $__env->startSection('headerTitle', $joblist->title . ' Details'); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"> <a href="<?php echo e(route('career.index')); ?>">Career</a> </li>
    <li><span class="icon-right-arrow"></span></li>
    <li class="breadcrumb-item active"><?php echo e($joblist->title); ?> Details</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="Vacancy for <?php echo e($joblist->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="Vacancy for <?php echo e($joblist->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <style>
        .services-details__content-text1 ul {
            list-style-type: disc;
            padding-left: 16px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($joblist->title . ' Details'); ?></h1>
    <section class="services-details">
        <div class="container">
            <div class="row">
                <!--Start Services Details Sidebar-->
                <div class="col-xl-4">
                    <div class="services-details__sidebar overflow-hidden">
                        <div class="services-details__sidebar-services px-3">
                            <div class="title-box">
                                <h2>Basic Information
                                </h2>
                            </div>

                            <ul class="services-details__sidebar-services-list mt-0">
                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-briefcase"></i>
                                        <strong>Job Title:</strong> <?php echo e($joblist->title); ?>

                                    </a>
                                </li>


                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-clock"></i>
                                        <strong>Employment Type:</strong> <?php echo e($joblist->time); ?>

                                    </a>
                                </li>


                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-user"></i>
                                        <strong>No. of Vacancy:</strong> <?php echo e($joblist->no_of_vacancy); ?>

                                    </a>
                                </li>


                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-university"></i>
                                        <strong>Education:</strong> <?php echo e($joblist->education); ?>

                                    </a>
                                </li>


                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-building"></i>
                                        <strong>Experience:</strong> <?php echo e($joblist->experince); ?>

                                    </a>
                                </li>


                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-money-bill-alt"></i>
                                        <strong>Salary:</strong> <?php echo e($joblist->salary); ?>

                                    </a>
                                </li>


                                <li>
                                    <a class="justify-content-start gap-2 align-items-center">
                                        <i class="far fa-calendar-alt"></i>
                                        <strong>Deadline:</strong>
                                        <?php echo e($joblist->deadline ? $joblist->deadline->format('d M, Y') : ''); ?>

                                    </a>
                                </li>

                            </ul>
                        </div>


                    </div>
                </div>
                <!--End Services Details Sidebar-->

                <!--Start Services Details Content-->
                <div class="col-xl-8">
                    <div class="services-details__content">

                        <div class="services-details__content-text1 mt-0">
                            <div class="title-box">
                                <h2><?php echo e($joblist->title); ?></h2>
                            </div>

                            <?php echo $joblist->description; ?>




                        </div>
                        <div class="apply-btn mt-4">

                            <a href="<?php echo e(route('career.apply', $joblist)); ?>" class="thm-btn">Apply Now<span
                                    class="icon-arrow-up-right"></span></a>
                        </div>
                    </div>
                </div>
                <!--End Services Details Content-->
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/careers/career-show.blade.php ENDPATH**/ ?>