<!-- Right side column. Contains the navbar and content of the page -->
<div class="row g-3">
    <div class="col-md-12">
        <div class="row g-3">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('products.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Products
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_products()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-cube-alt'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('offer-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('offers.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Offers
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_offers()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-gift'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shop-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('shops.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Shops
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_shops()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-home-smile'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('users.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Users
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_users()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-user'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>



            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('candidate-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('candidates.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Career Request
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_candidates()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-user-pin'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact-us-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('contact_forms.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Contact Request
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_contact_forms()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-user-voice'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscriber-list')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('subscribers.index')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Subscriber
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        <?php echo e(get_subscribers()->count()); ?>

                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-file'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin-setting')): ?>
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="<?php echo e(route('general.settings')); ?>" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Setting
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        -
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-cog'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>


    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product-request-list')): ?>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Product Request</h2>
                    </div>
                    <a href="<?php echo e(route('product_requests.index')); ?>" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Product</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(get_product_requests()): ?>
                                    <?php $__currentLoopData = get_product_requests()->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex">
                                                    <div class="">
                                                        <img style="width: 60px; height: 60px;"
                                                            src="<?php echo e($item->product ? $item->product->imageUrl : ''); ?>"
                                                            alt="">
                                                    </div>
                                                    <div class="ps-3">
                                                        <div class="">
                                                            <?php echo e($item->product ? $item->product->title : '-'); ?>

                                                        </div>
                                                        <div class="text-muted">
                                                            <?php echo e($item->name); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo e($item->created_at->format('d M, Y')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('offer-request-list')): ?>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Offer Request</h2>
                    </div>
                    <a href="<?php echo e(route('offer_requests.index')); ?>" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Product</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = get_offer_requests()->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="">
                                                    <img style="width: 60px; height: 60px;"
                                                        src="<?php echo e($item->offer->imageUrl); ?>" alt="">
                                                </div>
                                                <div class="ps-3">
                                                    <div class="">
                                                        <?php echo e($item->offer->title); ?>

                                                    </div>
                                                    <div class="text-muted">
                                                        <?php echo e($item->name); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($item->created_at->format('d M, Y')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dealer-enquiry-list')): ?>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Dealer Enquiry</h2>
                    </div>
                    <a href="<?php echo e(route('dealer_enquiries.index')); ?>" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Full Name</td>
                                    <td>Company</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = get_dealer_enquiries()->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="ps-3">
                                                    <div class="">
                                                        <?php echo e($item->name); ?>

                                                    </div>
                                                    <div class="text-muted">
                                                        <?php echo e($item->phone); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($item->company_name); ?></td>
                                        <td><?php echo e($item->created_at->format('d M, Y')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dealer-enquiry-list')): ?>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Customer Enquiry</h2>
                    </div>
                    <a href="<?php echo e(route('customer_enquiries.index')); ?>" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Full Name</td>
                                    <td>Address</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = get_customer_enquiries()->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="ps-3">
                                                    <div class="">
                                                        <?php echo e($item->name); ?>

                                                    </div>
                                                    <div class="text-muted">
                                                        <?php echo e($item->phone); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($item->address); ?></td>
                                        <td><?php echo e($item->created_at->format('d M, Y')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div><!-- /.content-wrapper -->


<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/backend/dashboard.blade.php ENDPATH**/ ?>